<?php

if (empty($_POST["username"])) {
    die('Please submit the form');
}

if (!filter_var($_POST["email"], FILTER_VALIDATE_EMAIL)) {
    die('Invalid email address');
}

$password_hash = password_hash($_POST["password"], PASSWORD_DEFAULT);

// Connect to the database
$mysqli = require __DIR__ . '/database.php';

try {
    // Prepare SQL statement
    $sql = "INSERT INTO user (name, email, password_hash) VALUES (?, ?, ?)";
    $stmt = $mysqli->stmt_init();

    if (! $stmt->prepare($sql)) {
        die('SQL error: ' . $mysqli->error);
    }

    $stmt->bind_param('sss', $_POST["username"], $_POST["email"], $password_hash);

    // Execute the statement
    if ($stmt->execute()) {
        header('Location: AccountLogin.php');
        exit;
    }

} catch (mysqli_sql_exception $e) {
    // Check if the error is a duplicate entry (error code 1062)
    if ($e->getCode() === 1062) {
        header('Location: emailUsed.php');
    } else {
        // Handle any other database errors
        die('Database error: ' . $e->getMessage());
    }
}
